#!/bin/bash
#==================================================================================================
# This shell script will launch the 'Multi Relay Chat' python script. It is intended to be called #
# via a forked systemd .service file. The script will check that mrc_client.py is not already     #
# running then will launch it. To avoid problems, it should be launched using the same user that  #
# owns the mystic install directory. If executing manually, use 'sudo -u username' or ensure you  #
# are logged into the terminal as the user that owns the mystic directory. In a systemd .service  #
# file, you should use the 'User=' option in the [Service] section. The script will exit with an  #
# appropriate error code to indicate whether is was successful or not. This script is indended to #
# work only with Debian, Ubuntu, Raspbian and other debian based distributions.                   #
#==================================================================================================

# MRC Variables:
MRC_PATH=/mystic
MRC_SERVER=mrc.bottomlessabyss.net
MRC_PORT=5000
MRC_PID=$(ps auxwww | grep "/usr/bin/python ./mrc_client.py" | grep -v grep | awk '{print $2}')

echo "Attempting to start the Multi Relay Chat (MRC) python script.."

# Make sure the mrc_client.py script isn't already running:
if [ ! -z "$MRC_PID" ]
then
    echo "Error: mrc_client.py script is already running at PID $MRC_PID. Stop it first."
    exit 1
fi

# Starting the MRC python script
cd $MRC_PATH >/dev/null
./mrc_client.py $MRC_SERVER $MRC_PORT &
cd - >/dev/null

# Wait 3 seconds and check for a PID
sleep 3
MRC_PID=$(ps auxwww | grep "/usr/bin/python ./mrc_client.py" | grep -v grep | awk '{print $2}')

# Making sure it started successfully
if [ ! -z "$MRC_PID" ]
then
    echo "Success! The mrc_client.py script is now running with PID $MRC_PID"
    exit 0
else
    echo "Error: mrc_client.py failed to start. Exiting."
    exit 1
fi