#!/bin/bash
#==================================================================================================
# This shell script will stop the 'Multi Relay Chat' python script. It is intended to be called   #
# via a forked systemd .service file. The script will check that mrc_client.py is running then    #
# will stop it via SIGTERM. If it can't be stopped gracefully within 30 seconds, it will be       #
# forcefully stopped. The script will exit with an appropriate error code to indicate whether it  #
# was successful or not. This script is indended to work only with Debian, Ubuntu, Raspbian and   #
# other debian based distributions.                                                               #
#==================================================================================================

# MRC Variables. Be sure to set your MRC script path (usually your main mystic directory)
MRC_PATH=/mystic
MRC_SERVER=mrc.bottomlessabyss.net
MRC_PORT=5000
MRC_PID=$(ps auxwww | grep "/usr/bin/python ./mrc_client.py" | grep -v grep | awk '{print $2}')

echo "Attempting to stop the Multi Relay Chat (MRC) python script.."

# Make sure the mrc_client.py script is running:
if [ -z "$MRC_PID" ]
then
    echo "Error: mrc_client.py is not running so can't be stopped."
    exit 1
fi

# Stopping the MRC python script
echo "The MRC PID is $MRC_PID. Sending a SIGTERM.."
kill -s TERM $MRC_PID

# Making sure it stopped successfully
MRC_COUNTER=0
echo "Checking to ensure the process stops.."

while [ $MRC_COUNTER -lt 6 ] 
do
    MRC_PID=$(ps auxwww | grep "/usr/bin/python ./mrc_client.py" | grep -v grep | awk '{print $2}')
    if [ ! -z "$MRC_PID" ]
    then
        echo "Process still running. Waiting 5 seconds.."
        sleep 5
    else
        echo "Finished! mrc_client.py script has been stopped successfully."
        exit 0
    fi
    let MRC_COUNTER=MRC_COUNTER+1 
done

# If it's still running after 30 seconds (6 intervals) then use kill -9
if [ "$MRC_COUNTER" -eq 6 ] && [ ! -z "$MRC_PID" ]
then
    echo "The mrc_client.py script failed to stop after 60 seconds. Stopping forcefully.."
    kill -9 $MRC_PID
fi

# Wait 5 seconds, then double check to ensure it stopped. Otherwise it's considered a failure.
sleep 5
MRC_PID=$(ps auxwww | grep "/usr/bin/python ./mrc_client.py" | grep -v grep | awk '{print $2}')
if [ ! -z "$MRC_PID" ]
then
    echo "Error: Failed to kill the mrc_client.py script."
    exit 1
else
    echo "Success. The mrc_client.py script was forcefully stopped."
    exit 0
fi